/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jasperreports.util;

import java.util.ArrayList;
import java.util.List;
import net.sf.jasperreports.engine.JRPropertiesMap;
import net.sf.jasperreports.engine.JRPropertiesUtil;
import net.sf.jasperreports.extensions.ExtensionsRegistry;
import net.sf.jasperreports.extensions.ExtensionsRegistryFactory;
import net.sf.jasperreports.extensions.ListExtensionRegistry;
import net.sf.jasperreports.util.CastorMapping;

public class CastorMappingExtensionsRegistryFactory
implements ExtensionsRegistryFactory {
    public static final String CASTOR_MAPPING_PROPERTY_PREFIX = "net.sf.jasperreports.extension.castor.mapping.";
    public static final char CASTOR_MAPPING_VERSION_SEPARATOR = '@';

    @Override
    public ExtensionsRegistry createRegistry(String registryId, JRPropertiesMap properties) {
        List<JRPropertiesUtil.PropertySuffix> castorMappingProperties = JRPropertiesUtil.getProperties(properties, CASTOR_MAPPING_PROPERTY_PREFIX);
        ArrayList<CastorMapping> castorMappings = new ArrayList<CastorMapping>();
        for (JRPropertiesUtil.PropertySuffix castorMappingProp : castorMappingProperties) {
            String version;
            String key;
            String suffix = castorMappingProp.getSuffix();
            int versionSeparatorIndex = suffix.lastIndexOf(64);
            if (versionSeparatorIndex < 0) {
                key = suffix;
                version = null;
            } else {
                key = suffix.substring(0, versionSeparatorIndex);
                version = suffix.substring(versionSeparatorIndex + 1, suffix.length());
            }
            String castorMappingPath = castorMappingProp.getValue();
            CastorMapping mapping = new CastorMapping(key, version, castorMappingPath);
            castorMappings.add(mapping);
        }
        return new ListExtensionRegistry<CastorMapping>(CastorMapping.class, castorMappings);
    }
}

